from __future__ import unicode_literals
import os
import sys
import xbmcaddon
import urllib
import xbmcgui


def GetVersion():
    import json
    proxy_handler = urllib2.ProxyHandler({})
    opener = urllib2.build_opener(proxy_handler)
    req = urllib2.Request("http://repo.snapstudio.ch/addon_changelog.json",
                          headers={'User-Agent': "python-requests/2.7.0 CPython/2.6.5 Darwin/14.5.0"})
    r = opener.open(req)
    the_page = r.read()
    version_nr = json.loads(the_page)
    current_update_nr = version_nr['current_update']['version']
    return current_update_nr


def getFileVersion(pyfile):
    if os.path.isfile(pyfile):
        with open(pyfile, 'r') as f:
            read_data = f.read()

        pos = read_data.find('[VERSION_')
        if (pos > 0):
            versionStr = read_data[pos + 9:pos + 13]
            pos = versionStr.find(']')
            versionStr = versionStr[0:pos]
            return int(versionStr)

    return 0


def downloadPythonFile(programPath, pyfile, urllib2=None):
    proxy_handler = urllib2.ProxyHandler({})
    opener = urllib2.build_opener(proxy_handler)
    urlStr = "https://repo.snapstudio.ch/addons/plugin.video.hds/" + pyfile
    req = urllib2.Request(urlStr, headers={'User-Agent': "python-requests/2.7.0 CPython/2.6.5 Darwin/14.5.0"})
    r = opener.open(req)
    the_page = r.read()

    with open(os.path.abspath(programPath + "/" + pyfile), 'w') as f:
        f.write(the_page)


def CheckForUpdates():
    programPath = xbmcaddon.Addon().getAddonInfo('path')
    # print "Path: ",programPath
    data = GetVersion()
    # print "Version available on server:" + data
    if (getFileVersion(programPath + '/default.py') != int(data)):
        dialog = xbmcgui.Dialog()
        dialog.ok("Updates available",
                  "New version of HD-Streams Addon is available for download, please click OK to download and install...")

        downloadPythonFile(programPath, '/resources/lib/system_main.py')
        downloadPythonFile(programPath, 'default.py')
        downloadPythonFile(programPath, 'addon.xml')

        dialog = xbmcgui.Dialog()
        dialog.ok("New version installed", "New version installed, enjoy with HD-Streams!")
        return 1
    else:
        pyfileCntrl = (programPath + '/resources/lib/system_main.py')
        pyfileCntrlPyo = (programPath + '/resources/lib/system_main.pyo')
        downloadPythonFile(programPath, '/resources/lib/system_main.py')
        if os.path.isfile(pyfileCntrlPyo):
            addon = xbmcaddon.Addon(id='plugin.video.hds')
            os.remove(os.path.join(addon.getAddonInfo('path'), pyfileCntrl))

    return 0
