#################################
import logging, time
import urllib, re
import xbmc, xbmcgui, xbmcvfs
import time
import shutil
import os
import os.path
import hashlib
import xbmcplugin
import xbmcaddon
import requests
import resources.lib.version_check as version_check
import string, sys, traceback, unicodedata
import xml.dom.minidom, base64
from xbmcaddon import Addon


import bs4 as bs

try:
    import json
except:
    import simplejson as json
ADDON = xbmcaddon.Addon('plugin.video.hdsv3')
PATH = sys.argv[0]


class hds:
    PLUGIN_MODE_BUILD_DIR = 10
    PLUGIN_MODE_PLAY_YT_VIDEO = 20
    PLUGIN_MODE_QUERY_DB = 30
    PLUGIN_MODE_QUERY_YT = 40
    PLUGIN_MODE_BUILD_YT_USER = 50
    PLUGIN_MODE_BUILD_YT_FAV = 60
    PLUGIN_MODE_PLAY_PLAYLIST = 80
    PLUGIN_MODE_OPEN_SETTINGS = 100
    PLUGIN_MODE_PLAY_STREAM = 110
    PLUGIN_MODE_QUERY_DM = 130
    PLUGIN_MODE_BUILD_DM_USER = 140
    PLUGIN_MODE_GET_USERINFO = 150
    PLUGIN_MODE_DOWNLOAD = 160
    PLUGIN_MODE_QUERY = 170
    PLUGIN_MODE_DELETE_CACHE = 180
    PLUGIN_MODE_DELETE_PACKAGE = 190
    PLUGIN_MODE_DELETE_THUMBNAILS = 200
    PLUGIN_MODE_OPEN_PLUGIN = 240
    PLUGIN_MODE_PLAY_YUPP_PAID = 310
    PLUGIN_MODE_PLAY_YUPP_FREE = 330
    PLUGIN_MODE_PLAY_HOTSTAR = 340
    PLUGIN_MODE_PLAY_EINTHUSAN = 350
    PLUGIN_MODE_PLAY_HEROTALKIES = 360
    PLUGIN_MODE_PLAY_LYCA = 370
    PLUGIN_MODE_PLAY_YUPP_FLIX = 380
    PLUGIN_MODE_PLAY_FETCH_TV_FROM_NET = 390
    PLUGIN_MODE_SETTINGS = 400
    PLUGIN_MODE_STATUS = 405
    PLUGIN_MODE_EXACT = 410
    PLUGIN_VIEW_LIST = 498
    PLUGIN_VIEW_BIGLIST = 499
    PLUGIN_VIEW_THUMB = 500
    PLUGIN_VIEW_POSTER = 501
    PLUGIN_VIEW_FANART = 502
    PLUGIN_VIEW_MEDIA = 503
    PLUGIN_VIEW_MEDIA2 = 504
    PLUGIN_VIEW_MEDIA3 = 505
    CUSTOM_VIEW_SHIFT = 53

    def __init__(self):
        self.base_url = 'https://hdstreams.ch'
        self.plugin_name = 'plugin.video.hdsv3'
        self.addon = xbmcaddon.Addon(self.plugin_name)
        self.plugin_ver = self.addon.getAddonInfo('version')
        self.profile = xbmcvfs.translatePath(self.addon.getAddonInfo('profile'))
        self.__settings__ = xbmcaddon.Addon(id=self.plugin_name)
        self.home = self.__settings__.getAddonInfo('path')
        self.favorites = xbmcvfs.translatePath(os.path.join(self.profile, 'favorites'))
        self.REV = xbmcvfs.translatePath(os.path.join(self.profile, 'list_revision'))
        self.icon = xbmcvfs.translatePath(os.path.join(self.home, 'icon.png'))
        self.fanart = xbmcvfs.translatePath(os.path.join(self.home, 'fanart.jpg'))

    def log(self, msg):
        xbmc.log(u'%s: %s' % ('HD-STREAMS', msg), level=xbmc.LOGNOTICE)

    def check_internet_on(self):
        try:
            urllib2.urlopen('http://google.com', timeout=1)
            return True
        except urllib2.URLError as err:
            return False

    def deletePackages(self):
        packagesPath = xbmcvfs.translatePath('special://home/addons/packages')
        dialog = xbmcgui.Dialog()
        for root, dirs, files in os.walk(packagesPath):
            file_count = 0
            file_count += len(files)

        if file_count != 0:
            if dialog.yesno('Delete Package Cache Files', '%d Packages Found.' % file_count, 'Delete Them?'):
                for root, dirs, files in os.walk(packagesPath):
                    file_count = 0
                    file_count += len(files)
                    if file_count > 0:
                        for f in files:
                            os.unlink(os.path.join(root, f))

                        for d in dirs:
                            rmtree(os.path.join(root, d))
        dialog = xbmcgui.Dialog()
        dialog.ok('Cleaning Done', 'Done clearing packages files.', 'Rebooting system is highly recommended!',
                  'Please restart Kodi.')

    def deleteThumbnails(self):
        thumbnailPath = xbmcvfs.translatePath('special://thumbnails')
        if os.path.exists(thumbnailPath) == True:
            dialog = xbmcgui.Dialog()
            if dialog.yesno("Delete Kodi '/thumbnails' Cache", 'This Option Deletes All Cached Thumbnails',
                            'Are You Sure You Want To Do This?'):
                for root, dirs, files in os.walk(thumbnailPath):
                    file_count = 0
                    file_count += len(files)
                    if file_count > 0:
                        for f in files:
                            try:
                                os.unlink(os.path.join(root, f))
                            except:
                                pass

        databasePath = xbmcvfs.translatePath('special://database')
        text13 = os.path.join(databasePath, 'Textures13.db')
        os.unlink(text13)
        dialog = xbmcgui.Dialog()
        dialog.ok('Cleaning Done', 'Done clearing thumbnails files.', 'Rebooting system is highly recommended!',
                  'Please restart Kodi.')

    def clearKodiCache(self):
        cachePath = os.path.join(xbmcvfs.translatePath('special://home'), 'cache')
        tempPath = xbmcvfs.translatePath('special://temp')
        if os.path.exists(cachePath):
            for root, dirs, files in os.walk(cachePath):
                file_count = 0
                file_count += len(files)
                if file_count > 0:
                    dialog = xbmcgui.Dialog()
                    if dialog.yesno("Delete Kodi '/cache' Files", str(file_count) + ' files found',
                                    'Do you want to delete them?'):
                        for f in files:
                            try:
                                if f == 'xbmc.log' or f == 'xbmc.old.log' or f == 'kodi.log' or f == 'kodi.old.log':
                                    continue
                                os.unlink(os.path.join(root, f))
                            except:
                                pass

                        for d in dirs:
                            try:
                                shutil.rmtree(os.path.join(root, d))
                            except:
                                pass

        if os.path.exists(tempPath) == True:
            for root, dirs, files in os.walk(tempPath):
                file_count = 0
                file_count += len(files)
                if file_count > 0:
                    dialog = xbmcgui.Dialog()
                    if dialog.yesno("Delete Kodi '/temp' Files", str(file_count) + ' files found',
                                    'Would you like to delete them?'):
                        for f in files:
                            try:
                                if f == 'xbmc.log' or f == 'xbmc.old.log' or f == 'kodi.log' or f == 'kodi.old.log':
                                    continue
                                os.unlink(os.path.join(root, f))
                            except:
                                pass

                        for d in dirs:
                            try:
                                rmtree(os.path.join(root, d))
                            except:
                                pass

        if xbmc.getCondVisibility('system.platform.ATV2'):
            atv2_cache_a = os.path.join('/private/var/mobile/Library/Caches/AppleTV/Video/', 'Other')
            for root, dirs, files in os.walk(atv2_cache_a):
                file_count = 0
                file_count += len(files)
                if file_count > 0:
                    dialog = xbmcgui.Dialog()
                    if dialog.yesno('Delete ATV2 Cache Files', str(file_count) + " files found in 'Other'",
                                    'Do you want to delete them?'):
                        for f in files:
                            os.unlink(os.path.join(root, f))

                        for d in dirs:
                            rmtree(os.path.join(root, d))

            atv2_cache_b = os.path.join('/private/var/mobile/Library/Caches/AppleTV/Video/', 'LocalAndRental')
            for root, dirs, files in os.walk(atv2_cache_b):
                file_count = 0
                file_count += len(files)
                if file_count > 0:
                    dialog = xbmcgui.Dialog()
                    if dialog.yesno('Delete ATV2 Cache Files', str(file_count) + " files found in 'LocalAndRental'",
                                    'Do you want to delete them ?'):
                        for f in files:
                            os.unlink(os.path.join(root, f))

                        for d in dirs:
                            rmtree(os.path.join(root, d))

        try:
            deleteThumbnails(self)
        except:
            pass

        try:
            deletePackages(self)
        except:
            pass

        dialog = xbmcgui.Dialog()
        dialog.ok('Cleaning Done', 'Done clearing cache and temp files.', 'Rebooting system is highly recommended!',
                  'Please restart Kodi to rebuild cache.')

    def open_settings(self):
        self.__settings__.openSettings()

    def getSources(self, data=None):
        if b'ACTIVE' in data.upper():
            thumb = self.base_url + '/members/api/images/userinfo.png'
        if self.addon.getSetting('Status') == 'true':
            self.addDir('USER INFO', '', self.PLUGIN_MODE_STATUS, thumb, self.fanart, '', '', '')
        if self.addon.getSetting('Setting') == 'true':
            self.addDir('SETTINGS', '', self.PLUGIN_MODE_SETTINGS, self.base_url + '/members/api/images/settings.png',
                        self.fanart, '', '', '')
        cache_url = self.cache(self.base_url + '/members/api/index.php?xymode=root')
        sources = json.loads(cache_url)
        if len(sources) > 0:
            for i in sources:
                if self.addon.getSetting(i['package_number']) == 'true':
                    if self.addon.getSetting('viewbypack') == 'true':
                        self.addDir(i['package_name'], i['package_link'], 1, i['package_logo'], self.fanart, '', '', '', hidecontext=False)
                    else:
                        self.getData(i['package_link'], self.fanart)
                else:
                    self.getData(i['package_link'], self.fanart)

                        

    def message(self, msg, title=''):
        if msg == 'error':
            return
        dialog = xbmcgui.Dialog()

        line = msg.split('\n')

        if len(line) >= 3:
            dialog.ok(title, line[0], line[1], line[2])
            return
        if len(line) == 2:
            dialog.ok(title, line[0], line[1])
            return
        if len(line) == 1:
            dialog.ok(title, line[0])
            return
        dialog.ok(title, msg)

    def getSoup(self, url):
        
        data = self.cache(url)
        text = data.decode('utf-8')
        soup = bs.BeautifulSoup(data, 'html.parser')
        return soup

    def getData(self, url, fanart):
        soup = self.getSoup(url)
        self.getItems(soup('item'), fanart)
        return

    def getItems(self, items, fanart):
        print ('ITEMS FROM URL'+ str(items))
        playlist = xbmc.PlayList(xbmc.PLAYLIST_VIDEO)
        vodFound = False
        total = len(items)

        for item in items:

            try:
                name = item('title')[0].string

            except:
                name = ''

            try:
                thumbnail = item('thumbnail')[0].string
                if thumbnail == None:
                    raise
            except:
                thumbnail = ''

            try:
                folder = item('folder')[0].string
                if folder == None:
                    raise
            except:
                folder = 'false'

            try:
                desc = item('description')[0].string
                if desc == None:
                    raise
            except:
                desc = ''
            try:
                guid = item('guid')[0].string
                if guid == None:
                    raise
            except:
                guid = ''

            try:
                context = item('context')[0].string
                if context == None:
                    raise
            except:
                context = ''

            try:
                view = item('view')[0].string
                if view == '498':
                    code = self.PLUGIN_VIEW_LIST
                elif view == '499':
                    code = self.PLUGIN_VIEW_BIGLIST
                elif view == '500':
                    code = self.PLUGIN_VIEW_THUMB
                elif view == '501':
                    code = self.PLUGIN_VIEW_POSTER
                elif view == '502':
                    code = self.PLUGIN_VIEW_FANART
                elif view == '503':
                    code = self.PLUGIN_VIEW_MEDIA
                elif view == '504':
                    code = self.PLUGIN_VIEW_MEDIA2
                elif view == '505':
                    code = self.PLUGIN_VIEW_MEDIA3
                elif view == '53':
                    code = self.CUSTOM_VIEW_SHIFT

                if code == None:
                    raise
            except:
                code = self.PLUGIN_VIEW_THUMB

            try:
                if not item('fanart'):
                    fanArt = fanart
                else:
                    fanArt = item('fanart')[0].string
                if fanArt == None:
                    raise
            except:
                fanArt = fanart

            try:
                urllist = []

                urllist = item('streamurl')

                for url in urllist:
                    if '.xml' in url.string or folder == 'true':
                        self.addDir(name.encode('utf-8', 'ignore'), url.string, 1, thumbnail, fanart, desc, '', '', True, code)

                    elif 'query' in url.string:
                        self.addDir(name.encode('utf-8', 'ignore'), url.string, 10, thumbnail, fanart, desc, '', '', True, code)

                    else:
                        url = url.string

                        if '|' not in url and self.addon.getSetting('origin') == 'true':

                            self.addLink(name.encode('utf-8', 'ignore'), url.string, 1, thumbnail, fanart, desc, '', '', total, code)

                            if self.addon.getSetting('mirror_links') == 'false':
                                break
                        else:
                            urls = url.split('|')

                            if urls[1] == 'us' and self.addon.getSetting('ustime') == 'true' or urls[1] == 'uk' and self.addon.getSetting('uktime') == 'true' or urls[1] == 'aus' and self.addon.getSetting('austime') == 'true':
                                self.addLink(name + ' [COLOR gold]' + urls[1].upper() + '[/COLOR]', urls[0], code, thumbnail, fanart, desc, '', '', total)

                                if self.addon.getSetting('mirror_links') == 'false':
                                    break
                            elif urls[1] != 'us' and urls[1] != 'uk' and urls[1] != 'aus' and urls[1] != '':
                                
                                self.addLink(name + ' [COLOR gold]' + urls[1].upper() + '[/COLOR]', urls[0], code, thumbnail, fanart, desc, '', '', total)
                                
                                if self.addon.getSetting('mirror_links') == 'false':
                                    break

                        
    

                if urllist == []:
                    raise
            except:
                try:
                    vodUrl = item('vod')[0].string
                except:
                    xbmc.log('no items found');

        return

    def get_params(self):
        param = []
        paramstring = sys.argv[2]
        if len(paramstring) >= 2:
            params = sys.argv[2]
            cleanedparams = params.replace('?', '')
            if params[len(params) - 1] == '/':
                params = params[0:len(params) - 2]
            pairsofparams = cleanedparams.split('&')
            param = {}
            for i in range(len(pairsofparams)):
                splitparams = {}
                splitparams = pairsofparams[i].split('=')
                if len(splitparams) == 2:
                    param[splitparams[0]] = splitparams[1]

        return param

    def getMode(self, url):

        if 'xymode' in url and 'lycafetch' in url:
            return self.PLUGIN_MODE_PLAY_LYCA
        elif 'chunklist' in url:
            return self.PLUGIN_MODE_PLAY_YUPP_FREE
        elif 'youtube.com' in url:
            return self.PLUGIN_MODE_PLAY_YT_VIDEO
        elif 'streamID' in url:
            return self.PLUGIN_MODE_PLAY_YUPP_FLIX
        elif 'chaID' in url and 'chaName' in url or 'yuppvod_new' in url:
            return self.PLUGIN_MODE_PLAY_YUPP_PAID
        elif 'contentId' in url and 'videos=yes' in url:
            return self.PLUGIN_MODE_PLAY_HOTSTAR
        elif 'xmode' in url and 'herotalkfetch' in url:
            return self.PLUGIN_MODE_PLAY_HEROTALKIES
        elif 'name' in url and 'fetch_tv_url.php' in url:
            return self.PLUGIN_MODE_PLAY_FETCH_TV_FROM_NET
        elif 'plugin://' in url:
            return self.PLUGIN_MODE_OPEN_PLUGIN
        elif 'einthusan' in url:
            return self.PLUGIN_MODE_PLAY_EINTHUSAN
        else:
            return self.PLUGIN_MODE_PLAY_STREAM

    def addDir(self, name, url, mode, iconimage, fanart, description, genre, date, hidecontext=True, view=500):
        ok = True
        liz = xbmcgui.ListItem(name)
        liz.setInfo(type='Video', infoLabels={'Title': name,
                                              'Plot': description,
                                              'Genre': genre,
                                              'Date': date})
        liz.setProperty('Fanart_Image', fanart)
        liz.setArt({'thumb': iconimage}) ## set thumb images for items
        contextMenuItems = []
        u = sys.argv[0] + '?url=%s&mode=%d&name=%s&fanart=%s&view=%d' % (urllib.parse.quote_plus(url),
                                                                         mode,
                                                                         urllib.parse.quote_plus(name),
                                                                         urllib.parse.quote_plus(fanart),
                                                                         view)

        liz.addContextMenuItems(contextMenuItems, replaceItems=hidecontext)
        ok = xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]), url=u, listitem=liz, isFolder=True)
        return ok

    def addLink(self, name, url, mode, iconimage, fanart, description, genre, date, total=None, showcontext=True, playlist=None):
    
        if 'youtube.com' in url:
            guid = url.replace('http://www.youtube.com/watch?v=', '')
        ok = True
        guid = ''

        liz = xbmcgui.ListItem(name)
        liz.setInfo(type='Video', infoLabels={'Title': name,
                                              'Plot': description,
                                              'Genre': genre})
        liz.setProperty('Fanart_Image', fanart)
        liz.setArt({'thumb': iconimage}) ## set thumb images for items
        contextMenuItems = []
        mode = self.getMode(url)
        if mode == self.PLUGIN_MODE_PLAY_STREAM:
            u = url

        if playlist == None:
            u = sys.argv[0] + '?mode=%d&name=%s&url=%s&thumb=%s&guid=%s' % (mode,
                                                                            urllib.parse.quote_plus(name),
                                                                            urllib.parse.quote_plus(url),
                                                                            urllib.parse.quote_plus(iconimage),
                                                                            guid)
        else:
            u = sys.argv[0] + '?mode=%d&name=%s&playlist=%s&thumb=%s&guid=%s' % (13,
                                                                                 urllib.parse.quote_plus(name),
                                                                                 urllib.parse.quote_plus(str(playlist).replace(',', '|')),
                                                                                 urllib.parse.quote_plus(iconimage),
                                                                                 guid)
        liz.addContextMenuItems(contextMenuItems, replaceItems=True)
        ok = xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]), url=u, listitem=liz, totalItems=total)
        return ok

    def get_match(self, data, regex):
        match = ''
        m = re.search(regex, data)
        if m is not None:
            match = m.group(1)
        else:
            match = ''
        return match

    def cache_page(self, url, isMobile=False, ref=''):
        req = urllib.request.Request(url)
        if isMobile:
            req.add_header('User-Agent',
                           'Mozilla/5.0 (iPhone; U; CPU iPhone OS 4_0 like Mac OS X; en-us) AppleWebKit/532.9 (KHTML, like Gecko) Version/4.0.5 Mobile/8A293 Safari/6531.22.7')
            req.add_header('User-Agent', 'Verismo-BlackUI_(2.4.7.5.8.0.34)')
        else:
            req.add_header('User-Agent',
                           'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/14.0.3 Safari/605.1.15')
        if ref != '':
            req.add_header('Referer', ref)
        response = urllib.request.urlopen(req)
        data = response.read().decode('utf-8')
        response.close()
        return data

    def cache(self, url):
        username = self.__settings__.getSetting('username')
        password = self.__settings__.getSetting('password')

        if username == '' or password == '':
            self.message(self.__settings__.getLocalizedString(30305).replace('\\n', '\n'), 'HD-STREAMS - MESSAGE')
            self.open_settings()
            exit()
        else:
            payload = {'username': username, 'password': password, 'loginformused': '1'}
            r = requests.post(url, payload)
            data = r.content
            return data

    def decodeEInth(self, lnk):
        t = 10
        r = lnk[0:t] + lnk[-1] + lnk[t + 2:-1]
        return r

    def encodeEInth(self, lnk):
        t = 10
        r = lnk[0:t] + lnk[-1] + lnk[t + 2:-1]
        return r

    def getUrl_with_cookie(self, url, cookieJar=None, post=None, timeout=20, headers=None, jsonpost=False):
        cookie_handler = urllib2.HTTPCookieProcessor(cookieJar)
        opener = urllib2.build_opener(cookie_handler, urllib2.HTTPBasicAuthHandler(), urllib2.HTTPHandler())
        header_in_page = None
        if '|' in url:
            url, header_in_page = url.split('|')
        req = urllib2.Request(url)
        req.add_header('User-Agent',
                       'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/33.0.1750.154 Safari/537.36')
        if headers:
            for h, hv in headers:
                req.add_header(h, hv)

        if header_in_page:
            header_in_page = header_in_page.split('&')
            for h in header_in_page:
                if len(h.split('=')) == 2:
                    n, v = h.split('=')
                else:
                    vals = h.split('=')
                    n = vals[0]
                    v = '='.join(vals[1:])
                req.add_header(n, v)

        if jsonpost:
            req.add_header('Content-Type', 'application/json')
        response = opener.open(req, post, timeout=timeout)
        if response.info().get('Content-Encoding') == 'gzip':
            from StringIO import StringIO
            import gzip
            buf = StringIO(response.read())
            f = gzip.GzipFile(fileobj=buf)
            link = f.read()
        else:
            link = response.read()
        response.close()
        return link

    def resolve_einthusan(self, url, name):
        self.log('Starting resolve_einthusan with url: ' + str(url))
        progress = xbmcgui.DialogProgress()
        progress.create('Progress', 'Fetching HQ Stream...')
        progress.update(20, 'Please wait...', 'Generating HQ Streams Links...', '')
        from HTMLParser import HTMLParser
        urlsplit = url.split('url=')
        guid = urlsplit[1].split('/')
        guid = guid[3]
        lang = urlsplit[1].split('=')
        lang = lang[1]
        import cookielib, json
        cookieJar = cookielib.LWPCookieJar()
        headers = [('Origin', 'https://einthusan.ca'), ('Referer', 'https://einthusan.ca/movie/browse/?lang=' + lang), (
        'User-Agent', base64.b64decode(
            'TW96aWxsYS81LjAgKFdpbmRvd3MgTlQgNi4xOyBXT1c2NCkgQXBwbGVXZWJLaXQvNTM3LjM2IChLSFRNTCwgbGlrZSBHZWNrbykgQ2hyb21lLzU1LjAuMjg4My44NyBTYWZhcmkvNTM3LjM2'))]
        mainurl = 'https://einthusan.ca/movie/watch/%s/?lang=%s' % (guid, lang)
        mainurlajax = 'https://einthusan.ca/ajax/movie/watch/%s/?lang=%s' % (guid, lang)
        htm = self.getUrl_with_cookie(mainurl, headers=headers, cookieJar=cookieJar)
        lnk = re.findall('data-ejpingables=["\'](.*?)["\']', htm)
        progress.update(50, 'Please wait..', 'Generating HQ Streams Links...', '')
        if lnk:
            lnk = re.findall('data-ejpingables=["\'](.*?)["\']', htm)[0]
            r = self.decodeEInth(lnk)
            jdata = '{"EJOutcomes":"%s","NativeHLS":false}' % lnk
            h = HTMLParser()
            gid = re.findall('data-pageid=["\'](.*?)["\']', htm)[0]
            gid = h.unescape(gid).encode('utf-8')
            postdata = {'xEvent': 'UIVideoPlayer.PingOutcome',
                        'xJson': jdata,
                        'arcVersion': '3',
                        'appVersion': '59',
                        'gorilla.csrf.Token': gid}
            postdata = urllib.urlencode(postdata)
            rdata = self.getUrl_with_cookie(mainurlajax, headers=headers, post=postdata, cookieJar=cookieJar)
            progress.update(70, 'Please Wait..', 'Playing HQ Stream', '')
            r = json.loads(rdata)['Data']['EJLinks']
            lnk = json.loads(self.decodeEInth(r).decode('base64'))['HLSLink']
            urlnew = lnk + '|https://einthusan.ca&Referer=%s&User-Agent=%s' % (mainurl,
                                                                               'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.87 Safari/537.36')
            self.log('Einthusan playable url is ' + str(urlnew))
            self.play_stream(urlnew, name)
            progress.update(100, name, 'Playing HQ Movie...')
        else:
            self.log('Einthusan playable url not found')
            xbmc.executebuiltin('Notification(Oops..,Video stream not found..,1000,' + self.icon + ')')
            return ''

    def open_plugin(self, url):
        xbmc.executebuiltin('activatewindow(video,' + url + ')')

    def play_yupp(self, url, name):
        name = name.split(' [')[0]
        if self.addon.getSetting('server1') != 'true':
            self.play_stream(url, name)
        else:
            data = self.cache_page(url, True)
            if self.get_match(data, '(http.+)') != '':
                location = self.get_match(data, '(http.+)')
                self.play_stream(location, name)
            elif self.get_match(data, '(chunklist.+)') != '':
                location = url.replace('playlist.m3u8', self.get_match(data, '(chunklist.+)'))
                self.play_stream(location, name)
        return

    def play_yupp_free(self, url, name):
        try:
            progress = xbmcgui.DialogProgress()
            progress.create('Progress', 'Fetching HQ Stream...')
            progress.update(20, 'Please wait...', 'Generating HQ Streams Links...', '')
            mobileagent = urllib.quote_plus(
                'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.0.2 Safari/605.1.15')
            progress.update(50, 'Please wait..', 'Generating HQ Streams Links...', '')

            progress.update(70, 'Please Wait..', 'Playing HQ Stream', '')
            self.play_stream(url + '|User-Agent=' + mobileagent, name)
            progress.update(100, name, 'Playing HQ Streams...')
        except:
            xbmc.executebuiltin(
                'Notification(Error Resolving Streams, Please try again later..,3000,' + self.icon + ')')
            return

    def delete(self, filename):
        if os.path.isfile(filename):
            os.remove(filename)
            return

    def fetch_yupp_token(self):
        file_path = os.path.join(self.profile, 'current_token')
        expiry_token_time = time.time() - 2700
        if os.path.isfile(file_path):
            if os.stat(file_path).st_mtime < expiry_token_time:
                self.delete(file_path)
        if os.path.isfile(file_path):
            f = open(file_path, 'r')
            token = base64.b64decode(f.read())
            f.close()
        else:
            import random
            urlList = ['110',
                       '810',
                       '159',
                       '169']
            cid = random.choice(urlList)
            url = 'http://stream.yupptv.com/PreviewPaidChannel.aspx?cid=' + cid
            data = self.cache_page(url)
            token = self.get_match(data, "manifest.f4m(.*?)'")
            if token != '':
                f = open(file_path, 'w')
                f.write(base64.b64encode(token))
                f.close()
        return token

    def yuppTV_Paid_Version(self, url, name):

        try:
            
            progress = xbmcgui.DialogProgress()
            progress.create('Progress', 'Fetching HQ Stream...')
            progress.update(20, 'Please wait...')
            data = self.cache_page(url)
            progress.update(40, 'Please wait..')
            location = self.get_match(data, '(http.+)')
            progress.update(80, 'Please wait..')
            self.play(location, name)
            progress.update(100, 'Please wait..')
                

        except:
            xbmc.executebuiltin('Notification(Error Resolving Stream, Please try again later..,3000,' + self.icon + ')')
            return

    def play(self, url, name, ref=''):
        player = xbmc.Player()
        listitem = xbmcgui.ListItem(label=str(name), path=url, offscreen=True)
        listitem.setInfo(type='video', infoLabels={'Title': name, 'Path': url})
        player.play(str(url), listitem)
        return

    

    def play_yupp_flix(self, url, name):

        try:
            progress = xbmcgui.DialogProgress()
            progress.create('Progress', 'Fetching HQ Movie...')
            progress.update(20, 'Please wait...', 'Generating HQ Movie Links...', '')
            mobileagent = urllib.quote_plus(
                'Macintosh; Intel Mac OS X 10_9_3) AppleWebKit/537.75.14 (KHTML, like Gecko) Version/7.0.3 Safari/7046A194A')
            data = self.cache(url)
            progress.update(50, 'Please wait..', 'Generating HQ Movie Links...', '')
            if self.get_match(data, '(http.+)') != '':
                location = self.get_match(data, '(http.+)')
                self.play_stream(location + '|User-Agent=' + mobileagent, name)
                progress.update(100, name, 'Playing HQ Movie...')
        except:
            xbmc.executebuiltin('Notification(Error Resolving Stream, Please try again later..,3000,' + self.icon + ')')
            return

    def play_youtube_video(self, video_id, name):
        video_id = video_id.replace("https://www.youtube.com/watch?v=", "")
        url = 'plugin://plugin.video.youtube/?action=play_video&videoid=%s' % video_id
        listitem = xbmcgui.ListItem(label=str(name), iconImage='DefaultVideo.png',
                                    thumbnailImage=xbmc.getInfoImage('ListItem.Thumb'), path=url)
        infolabels = {'Title': name,
                      'Path': url}
        listitem.setInfo(type='Video', infoLabels=infolabels)
        xbmc.Player().play(str(url), listitem)
        return

    def play_hotstar(self, url, name):
        # data = self.cache_page(url, True)
        session = requests.session()
        data1 = session.get(url, headers={
            'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
            'Accept-Encoding': 'gzip, deflate, sdch', 'Connection': 'keep-alive',
            'User-Agent': 'AppleCoreMedia/1.0.0.12B411 (iPhone; U; CPU OS 8_1 like Mac OS X; en_gb)',
            'X-Forwarded-For': '221.134.64.0'},
                            cookies=session.cookies, verify=False)
        data = data1.text
        if self.get_match(data, '(http.+)') != '':
            location = self.get_match(data, '(http.+)')
            url = location.strip()
            self.play_stream(url, name)
        return

    def play_herotalkies(self, url, name):
        try:
            progress = xbmcgui.DialogProgress()
            progress.create('Progress', 'Fetching HQ Movie...')
            progress.update(20, 'Please wait...', 'Generating HQ Movie Links...', '')
            mobileagent = urllib.quote_plus(
                'Macintosh; Intel Mac OS X 10_9_3) AppleWebKit/537.75.14 (KHTML, like Gecko) Version/7.0.3 Safari/7046A194A')
            data = self.cache(url)
            progress.update(50, 'Please wait..', 'Generating HQ Movie Links...', '')
            if self.get_match(data, '(http.+)') != '':
                location = self.get_match(data, '(http.+)')
                self.play_stream(location + '|User-Agent=' + mobileagent, name)
                progress.update(100, name, 'Playing HQ Movie...')
        except:
            xbmc.executebuiltin('Notification(Error Resolving Stream, Please try again later..,3000,' + self.icon + ')')
            return

    def play_fetch_tv_from_net(self, url, name):
        if 'athavan_tv' in url:
            progress = xbmcgui.DialogProgress()
            progress.create('Progress', 'Fetching HQ Streams...')
            progress.update(20, 'Please wait...', 'Generating HQ Streams Links...', '')
            data = self.cache_page('http://athavantv.com/live/live-athavan.php')
            progress.update(80, 'Please wait..', 'Generating HQ Streams Links...', '')
            streamurl = self.get_match(data, '(file: ".*")')
            streamurl = streamurl.split('"')
            finalstreamUrl = streamurl[1]
            progress.update(100, name, 'Playing HQ Streams...')
            self.play_stream(finalstreamUrl, name)
        else:
            try:
                progress = xbmcgui.DialogProgress()
                progress.create('Progress', 'Fetching HQ Streams...')
                progress.update(20, 'Please wait...', 'Generating HQ Movie Links...', '')
                mobileagent = urllib.quote_plus(
                    'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36 Edge/16.16299')
                data = self.cache(url)
                progress.update(80, 'Please wait..', 'Generating HQ Streams Links...', '')
                if self.get_match(data, '(http.+)') != '':
                    location = self.get_match(data, '(http.+)')
                    self.play_stream(location + '|User-Agent=' + mobileagent, name)
                    progress.update(100, name, 'Playing HQ Streams...')
            except:
                xbmc.executebuiltin(
                    'Notification(Error Resolving Stream, Please try again later..,3000,' + self.icon + ')')
                return

    def play_lyca(self, url, name):
        try:
            progress = xbmcgui.DialogProgress()
            progress.create('Progress', 'Fetching HQ Streams...')
            progress.update(20, 'Please wait...', 'Generating HQ Streams Links...', '')
            mobileagent = urllib.quote_plus('Lyca TV/1.0.7 (AppMastery.Lyca-TV; build:21; tvOS 11.3.0) Alamofire/4.4.0')
            data = self.cache_page(url)
            progress.update(50, 'Please wait..', 'Generating HQ Streams Links...', '')
            if self.get_match(data, '(http.+)') != '':
                mainUrl = self.get_match(data, '(http.+)')
                headers = {'User-Agent': 'Lyca TV/1.0.7 (AppMastery.Lyca-TV; build:21; tvOS 11.3.0) Alamofire/4.4.0'}
                session = requests.session()
                file_path = os.path.join(self.profile, 'current_token')
                expiry_token_time = time.time() - 3000
                progress.update(70, 'Please wait..', 'Generating HQ Streams Links...', '')
                if os.path.isfile(file_path):
                    if os.stat(file_path).st_mtime < expiry_token_time:
                        self.delete(file_path)
                    else:
                        f = open(file_path, 'r')
                        token = f.read()
                        f.close()
                        payload2 = {'device_id': '33', 'serial': 'A44E9CEE397641BF8456ABAF3B1776FF', 'token': token}
                        r2 = session.post(mainUrl, data=payload2, headers=headers)
                        content = r2.content
                        location = json.loads(content)
                        status = location['status']
                        if status == 'failed':
                            self.delete(file_path)

                if os.path.isfile(file_path):
                    f = open(file_path, 'r')
                    token = f.read()
                    f.close()
                else:
                    payload = {'device_id': '33', 'serial': 'A44E9CEE397641BF8456ABAF3B1776FF', 'pin': '4FAD9395'}
                    r = session.post('http://app-api.asiamediaglobal.org/app_mastery/login/verify', data=payload,
                                     headers=headers)
                    content = r.content
                    token = json.loads(content)
                    token = token['response']['token']
                    f = open(file_path, 'w')
                    f.write(token)
                    f.close()

                payload2 = {'device_id': '33', 'serial': 'A44E9CEE397641BF8456ABAF3B1776FF', 'token': token}
                r2 = session.post(mainUrl, data=payload2, headers=headers)
                content = r2.content
                progress.update(90, 'Please wait..', 'Generating HQ Streams Links...', '')
                location = json.loads(content)

                location = location['response']['url']
                self.play_stream(location + '|User-Agent=' + mobileagent, name)
                progress.update(100, name, 'Playing HQ Streams...')


        except:
            xbmc.executebuiltin('Notification(Error Resolving Stream, Please try again later..,3000,' + self.icon + ')')
            return

    def play_stream(self, url, name, ref=''):
        player = xbmc.Player()
        if player.isPlaying():
            player.stop()
        if ref is None or ref == '':
            pass
        else:
            url = url + '|referer=' + ref
        listitem = xbmcgui.ListItem(label=str(name), path=url, offscreen=True)
        listitem.setInfo(type='video', infoLabels={'Title': name, 'Path': url})
        player.play(str(url), listitem)
        return

    def build_show_directory(self, origurl):
        try:
            keyb = xbmc.Keyboard('', 'Search for Movies')
            keyb.doModal()
            if (keyb.isConfirmed()):
                search_term = urllib.quote_plus(keyb.getText())
                search_url = origurl + search_term
                data = self.getData(search_url, self.fanart)
        except:
            pass

    def get_category(self, url, name, iconimage, fanart, origurl, shareurl, thumb, guid, mode, page, index, ref, view):
        if mode == None:
            data = self.cache(self.base_url + '/members/api/status.php')
            # version_check.CheckForUpdates()
            self.getSources(data)
        elif mode == 1:
            self.getData(url, fanart)
        elif mode == self.PLUGIN_MODE_BUILD_DIR:
            self.build_show_directory(url)
        elif mode == self.PLUGIN_MODE_PLAY_YT_VIDEO:
            self.play_youtube_video(url, name)
        elif mode == self.PLUGIN_MODE_DELETE_CACHE:
            self.clearKodiCache()
        elif mode == self.PLUGIN_MODE_DELETE_PACKAGE:
            self.deletePackages()
        elif mode == self.PLUGIN_MODE_DELETE_THUMBNAILS:
            self.deleteThumbnails()
        elif mode == self.PLUGIN_MODE_PLAY_STREAM:
            self.play_stream(url, name)
        elif mode == self.PLUGIN_MODE_OPEN_SETTINGS:
            self.open_settings()
        elif mode == self.PLUGIN_MODE_DOWNLOAD:
            self.download(url, name, guid)
        elif mode == self.PLUGIN_MODE_QUERY:
            self.custom_search_directory(url, name)
        elif mode == self.PLUGIN_MODE_OPEN_PLUGIN:
            self.open_plugin(url)
        elif mode == self.PLUGIN_MODE_PLAY_YUPP_PAID:
            self.yuppTV_Paid_Version(url, name)
        elif mode == self.PLUGIN_MODE_PLAY_YUPP_FLIX:
            self.play_yupp_flix(url, name)
        elif mode == self.PLUGIN_MODE_PLAY_YUPP_FREE:
            self.play_yupp_free(url, name)
        elif mode == self.PLUGIN_MODE_PLAY_HOTSTAR:
            self.play_hotstar(url, name)
        elif mode == self.PLUGIN_MODE_PLAY_HEROTALKIES:
            self.play_herotalkies(url, name)
        elif mode == self.PLUGIN_MODE_PLAY_FETCH_TV_FROM_NET:
            self.play_fetch_tv_from_net(url, name)
        elif mode == self.PLUGIN_MODE_PLAY_LYCA:
            self.play_lyca(url, name)
        elif mode == self.PLUGIN_MODE_PLAY_EINTHUSAN:
            self.resolve_einthusan(url, name)
        elif mode == self.PLUGIN_MODE_SETTINGS:
            self.addon.openSettings()
            exit()
        elif mode == self.PLUGIN_MODE_STATUS:
            data = self.cache(
                self.base_url + '/members/api/index.php?xymode=status&user=' + self.addon.getSetting('username'))
            self.message(data, '[B]ACCOUNT STATUS[/B]')
            exit()
        if view != None or view == '':
            xbmc.executebuiltin('Container.SetViewMode(%s)' % view)
        else:
            xbmc.executebuiltin('Container.SetViewMode(500)')
        return
