from __future__ import unicode_literals
import os
import sys
import xbmcaddon
import urllib
import xbmcgui
import requests


def GetVersion():
    import json
    s = requests.Session()
    r = s.get('https://repo.snapstudio.ch/addon_changelog.json', headers={'User-Agent': "python-requests/2.7.0 CPython/2.6.5 Darwin/14.5.0"})
    #print(r.status_code)
    version_nr = json.loads(r.text)
    current_update_nr = version_nr['current_update']['version']
    return current_update_nr


def getFileVersion(pyfile):
    if os.path.isfile(pyfile):
        with open(pyfile, 'r') as f:
            read_data = f.read()

        pos = read_data.find('[VERSION_')
        if (pos > 0):
            versionStr = read_data[pos + 9:pos + 13]
            pos = versionStr.find(']')
            versionStr = versionStr[0:pos]
            return int(versionStr)

    return 0


def downloadPythonFile(programPath, pyfile, urllib=None):
    s = requests.Session()
    urlStr = "https://repo.snapstudio.ch/addons/plugin.video.hdsv3/" + pyfile
    req = s.get(urlStr, headers={'User-Agent': "python-requests/2.7.0 CPython/2.6.5 Darwin/14.5.0"})
    if req.status_code == 200:
        the_page = req.text
        with open(os.path.abspath(programPath + "/" + pyfile), 'w') as f:
            f.write(the_page)
    else:
        return

    


def CheckForUpdates():
    programPath = xbmcaddon.Addon().getAddonInfo('path')
    # print "Path: ",programPath
    data = GetVersion()
    # print "Version available on server:" + data
    if (getFileVersion(programPath + '/default.py') != int(data)):
        dialog = xbmcgui.Dialog()
        dialog.ok("Updates available",
                  "New version of HD-Streams Addon is available for download, please click OK to download and install...")

        downloadPythonFile(programPath, '/resources/lib/system_main.py')
        downloadPythonFile(programPath, 'default.py')
        downloadPythonFile(programPath, 'addon.xml')

        dialog = xbmcgui.Dialog()
        dialog.ok("New version installed", "New version installed, enjoy with HD-Streams!")
        return 1
    else:
        pyfileCntrl = (programPath + '/resources/lib/system_main.py')
        pyfileCntrlPyo = (programPath + '/resources/lib/system_main.pyo')
        downloadPythonFile(programPath, '/resources/lib/system_main.py')
        if os.path.isfile(pyfileCntrlPyo):
            addon = xbmcaddon.Addon(id='plugin.video.hdsv3')
            os.remove(os.path.join(addon.getAddonInfo('path'), pyfileCntrl))

    return 0
